// Canção do Despertar - JavaScript

document.addEventListener('DOMContentLoaded', function() {
    console.log('Canção do Despertar carregado');
    
    // Remover tela de loading após 3 segundos
    setTimeout(() => {
        const loadingScreen = document.getElementById('loading-screen');
        if (loadingScreen) {
            loadingScreen.style.opacity = '0';
            setTimeout(() => {
                loadingScreen.style.display = 'none';
            }, 500);
        }
    }, 3000);
    
    // Navegação entre seções
    const navButtons = document.querySelectorAll('.nav-btn');
    const sections = document.querySelectorAll('section');
    
    navButtons.forEach(button => {
        button.addEventListener('click', () => {
            const targetSection = button.getAttribute('data-section');
            
            // Remover classe active de todos os botões
            navButtons.forEach(btn => btn.classList.remove('active'));
            // Adicionar classe active ao botão clicado
            button.classList.add('active');
            
            // Scroll suave para a seção
            const section = document.getElementById(targetSection);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        });
    });
    
    // Botão PERMITA-SE
    const permitaSeBtn = document.getElementById('permita-se-btn');
    if (permitaSeBtn) {
        permitaSeBtn.addEventListener('click', () => {
            alert('Bem-vindo à jornada sonora! Feche os olhos e permita-se sentir...');
        });
    }
    
    // Botão Área Sagrada
    const areaSagradaBtn = document.getElementById('area-sagrada-btn');
    if (areaSagradaBtn) {
        areaSagradaBtn.addEventListener('click', () => {
            const areaSagradaSection = document.getElementById('area-sagrada');
            if (areaSagradaSection) {
                areaSagradaSection.scrollIntoView({ behavior: 'smooth' });
            }
        });
    }
    
    // Player de música
    const audio = document.querySelector('audio');
    const playPauseBtn = document.querySelector('.play-pause-btn');
    const progressBar = document.querySelector('.progress-bar');
    const progress = document.querySelector('.progress');
    const currentTimeSpan = document.querySelector('.current-time');
    const durationSpan = document.querySelector('.duration');
    
    if (audio && playPauseBtn) {
        let isPlaying = false;
        
        playPauseBtn.addEventListener('click', () => {
            if (isPlaying) {
                audio.pause();
                playPauseBtn.innerHTML = '<i class="fas fa-play"></i>';
                isPlaying = false;
            } else {
                audio.play().catch(e => {
                    console.log('Erro ao reproduzir áudio:', e);
                    alert('Para reproduzir a música, é necessário interação do usuário. Clique novamente.');
                });
                playPauseBtn.innerHTML = '<i class="fas fa-pause"></i>';
                isPlaying = true;
            }
        });
        
        // Atualizar barra de progresso
        audio.addEventListener('timeupdate', () => {
            if (audio.duration) {
                const progressPercent = (audio.currentTime / audio.duration) * 100;
                progress.style.width = progressPercent + '%';
                
                // Atualizar tempo atual
                if (currentTimeSpan) {
                    currentTimeSpan.textContent = formatTime(audio.currentTime);
                }
            }
        });
        
        // Definir duração quando carregada
        audio.addEventListener('loadedmetadata', () => {
            if (durationSpan) {
                durationSpan.textContent = formatTime(audio.duration);
            }
        });
        
        // Clique na barra de progresso
        if (progressBar) {
            progressBar.addEventListener('click', (e) => {
                const rect = progressBar.getBoundingClientRect();
                const clickX = e.clientX - rect.left;
                const width = rect.width;
                const clickPercent = clickX / width;
                
                if (audio.duration) {
                    audio.currentTime = clickPercent * audio.duration;
                }
            });
        }
    }
    
    // Função para formatar tempo
    function formatTime(seconds) {
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = Math.floor(seconds % 60);
        return `${minutes}:${remainingSeconds.toString().padStart(2, '0')}`;
    }
    
    // Efeitos de scroll
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        const parallax = document.querySelector('.hero-background');
        
        if (parallax) {
            const speed = scrolled * 0.5;
            parallax.style.transform = `translateY(${speed}px)`;
        }
    });
    
    // Animações de entrada
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('fade-in');
            }
        });
    }, observerOptions);
    
    // Observar todas as seções
    sections.forEach(section => {
        observer.observe(section);
    });
});

// Função para detectar seção ativa durante scroll
window.addEventListener('scroll', () => {
    const sections = document.querySelectorAll('section');
    const navButtons = document.querySelectorAll('.nav-btn');
    
    let current = '';
    
    sections.forEach(section => {
        const sectionTop = section.offsetTop;
        const sectionHeight = section.clientHeight;
        
        if (window.pageYOffset >= sectionTop - 200) {
            current = section.getAttribute('id');
        }
    });
    
    navButtons.forEach(button => {
        button.classList.remove('active');
        if (button.getAttribute('data-section') === current) {
            button.classList.add('active');
        }
    });
});
